/****************************************************
 *                                                  *
 * ļ: 06 Ͷ\06 ChildTree             *
 *                                                  *
 * ļ: ChildTree.h                              *
 *    	    			                            *
 *   : ĺ(˫)洢ʾزб *
 *                                                  *
 ****************************************************/

#ifndef CHILDTREE_H
#define CHILDTREE_H

#include <stdio.h>
#include <stdlib.h>										//ṩmallocreallocfreeexitԭ
#include "../../01 /Status.h"						//**01 **//
#include "../../01 /Scanf.c"						//**01 **//
#include "../../03 ջͶ/07 LinkQueue/LinkQueue.c" //**03 ջͶ**//
#include "../../03 ջͶ/01 SequenceStack/SequenceStack.c"	//**03 ջͶ**// 

/* 궨 */
#define MAX_TREE_SIZE 100						//

/* Ͷ */
typedef char TElemType_C;						//ԪؾΪַ
typedef struct CTNode							//ӽ 
{
	int child;
	struct CTNode* next;
}CTNode;
typedef CTNode* ChildPtr;						//ӽָ 
typedef struct
{
	int parent;									//˫׽λ 
	TElemType_C data;
	ChildPtr firstchild;						//ͷָ 
}CTBox;
typedef struct
{
	CTBox nodes[MAX_TREE_SIZE];
	int r;										//λ 
	int n;										//Ľ 
}CTree; 

/* ĺ洢ṹб */
void InitTree_C(FILE *fp, CTree *T);
/*
(01)T (ʼ)
*/

void FreeChild_C(ChildPtr *p);
/*
(02)ɾ
*/

void ClearTree_C(CTree *T);
/*
(03)T 
*/

void DestroyTree_C(CTree *T);
/*
(04)T 
*/

Status TreeEmpty_C(CTree T);
/*
(05)жTǷΪա 
*/

Status CreateTree_C(FILE *fp, CTree *T); 
/*
(06)й
*/

int TreeDegree_C(CTree T);
/*
(07)Ķȡ
*/

int TreeDepth_C_1(CTree T);
/*
(08-1)ȣ˫ױ־
*/

int TreeDepth_C_2(CTree T);
/*
(08-2)ȣ˫ױ־
*/

int Depth_C(CTree T, int i);
/*
(09)Tеi㿪ʼȡ
*/

TElemType_C Root_C(CTree T); 
/*
(10)ĸֵ
*/

TElemType_C Value_C(CTree T, int i);
/*
(11)еiֵ 
*/

int Order_C(CTree T, TElemType_C e);
/*
(12)ؽeֵλ(λ)-1޴˽㡣 
*/

Status Assign_C(CTree *T, TElemType_C e, TElemType_C value);
/*
(13)滻eֵΪvalue
*/

TElemType_C ChildValue_C(CTree T, TElemType_C e, int order);
/*
(14)ؽeĵorderӵֵҼ
*/

TElemType_C Sibling_C_1(CTree T, TElemType_C e, int mark);
/*
(15-1)Ԫeңֵܣmarkҡ 
*/

int Sibling_C_2(CTree T, int order, int mark);
/*
(15-2)ΪiĽңֵܵţmarkҡ 
*/

int ChildCount_C(CTree T, TElemType_C p);
/*
(16)ؽpĺӽ㣨ظpڡ
*/

int ChildSeat_C(CTree T, TElemType_C p, int i);
/*
(17)Tpĵiӣλãi=0Ϊһӡ
*/

ChildPtr SiblingSeat_C(CTree T, TElemType_C p);
/*
(18)ںָԪpָ롣 
*/

Status InsertChild_C(CTree *T, TElemType_C p, int i, TElemType_C e);
/*
(19)eΪTpĵiӣi=0Ϊһӡ 
*/

Status InsertTree_C(CTree *T, TElemType_C p, int i, CTree t);
/*
(20)tΪTpĵii=0Ϊһ 
*/

Status DeleteTree_C(CTree *T, TElemType_C p, int i);
/*
(21)ɾTpĵi 
*/

void LevelOrderTraverse_C(CTree T, void(Visit)(TElemType_C));
/*
(22)
*/

void Print_C_1(CTree T);
/*
(23-1)˫׽Ϣӡ
*/

void Print_C_2(CTree T, int start, int step);
/*
(23-2)˫׽԰ʽӡ
*/

void ShowTree_C(CTree T);
/*
(24)չʾĴ洢ṹ
*/

#endif
